<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:p="http://www.sec.gov/edgar/ta/tawfiler"	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes">
	<xsl:template name="Item1">
		<h3>
			Registration Information
		</h3>
		<xsl:call-template name="registrationInfo" />
	</xsl:template>

	<xsl:template name="registrationInfo" >
	<table role="presentation">
		<tr>
			<td class="label"><b>2.</b> Transfer Agent File No.:</td>
			<td>
				<div class="fakeBox2">
					<xsl:call-template name="FileNoLink" >
						<xsl:with-param name="aFileNumber" select="p:formData/p:registrant/p:fileNumber"></xsl:with-param>	
						<xsl:with-param name="label" select="p:formData/p:registrant/p:fileNumber"></xsl:with-param>									
					</xsl:call-template>
				</div>
			</td>
		</tr>
		<tr>
			<td class="label"><b>3.</b> Full name of registrant:</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="p:formData/p:registrant/p:entityName" />
				</div>
			</td>
		</tr>
		<tr>
			<td class="label"><b>4.</b> Name under which transfer agent activities are conducted, if different from above:</td>
			<td>
				<div class="fakeBox3">
					<xsl:value-of select="p:formData/p:registrant/p:activitiesConductedEntityName" />
				</div>
			</td>
		</tr>
	</table>
	
	<table role="presentation" >
	<tr>
		<h4>
			<b>5.</b> Address of registrants principle place of business:
		</h4>
	</tr>
	</table>
			<!-- repeatable -->
		<xsl:for-each select="p:formData/p:registrant/p:businessAddress">
			<table role="presentation" >
				<tr>
					<td class="label"><b>5(a).</b> Address </td>
					<td>
						<p>
							<div class="fakeBox3">
								<xsl:value-of select="ns1:street1" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label"><b>5(b).</b> Address 2 </td>
					<td>
						<p>
							<div class="fakeBox3">
								<xsl:value-of select="ns1:street2" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label"><b>5(c).</b> City </td>
					<td>
						<p>
							<div class="fakeBox2">
								<xsl:value-of select="ns1:city" />
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label"><b>5(d).</b> State or Country </td>
					<td>
						<p>
							<div class="fakeBox3">
							<xsl:call-template name="stateDescription">
								<xsl:with-param name="stateCode"
									select="string(./ns1:stateOrCountry)" />
							</xsl:call-template>
								<span>
									<xsl:text>&#160;</xsl:text>
								</span>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label"><b>5(e).</b> Postal Code </td>
					<td>
						<p>
							<div align="left">
								<div class="fakeBox2">
									<xsl:value-of select="ns1:zipCode" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</div>
						</p>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>